import React from 'react';
import * as Tabs from '@radix-ui/react-tabs';
import { useTranslation } from 'react-i18next';

export interface TabItem {
  id: string;
  label: string;
}

interface ResponsiveTabsProps {
  tabs: TabItem[];
  activeTab: string;
  setActiveTab: (id: string) => void;
}

export default function ResponsiveTabs({ tabs, activeTab, setActiveTab }: ResponsiveTabsProps) {
  const { t, i18n } = useTranslation();

  const tabsToRender = i18n.language === 'he' ? tabs.slice().reverse() : tabs;

  return (
    <div className="w-full">
      {/* Desktop Tabs */}
      <Tabs.Root value={activeTab} onValueChange={setActiveTab} className="flex w-full border-b">
        <Tabs.List
          className={`flex w-full ${i18n.language === 'he' ? 'justify-end' : ''}`}
          dir={i18n.language === 'he' ? 'rtl' : 'ltr'}
          style={i18n.language === 'he' ? { flexDirection: 'row-reverse' } : {}}
        >
          {tabsToRender.map(tab => (
            <Tabs.Trigger
              key={tab.id}
              value={tab.id}
              className={`flex-1 px-2 sm:px-4 py-2 sm:py-3 text-center font-medium transition-colors text-sm sm:text-base
                ${activeTab === tab.id ? 'border-b-2 border-blue-600 text-black bg-[#A3D9F2]' : 'text-gray-500 hover:text-blue-600'}
              `}
            >
              {t(`adminPanel.${tab.id}`, tab.label)}
            </Tabs.Trigger>
          ))}
        </Tabs.List>
      </Tabs.Root>
    </div>
  );
} 