import { NextResponse } from 'next/server';
import { postgresClient } from '../../../../lib/postgresql-client';

export async function GET() {
  try {
    // Получить все устройства и их значения + user info
    const query = `
      SELECT 
        d.device_name,
        dmv.max_value,
        dmv.current_read,
        dmv.valve_state,
        dmv.battery_voltage,
        d.device_type,
        dmv."80%",
        dmv."85%",
        dmv."90%",
        dmv."100%",
        u.f_name,
        u.s_name,
        u.device_id
      FROM devices d
      LEFT JOIN device_max_value dmv ON d.device_name = dmv.device_name
      LEFT JOIN users u ON d.device_name = u.device_id
    `;
    const result = await postgresClient.query(query);

    // Получить общее количество устройств
    const totalDevicesRes = await postgresClient.query('SELECT COUNT(*) FROM devices');
    const totalDevices = Number(totalDevicesRes.rows[0].count);

    // Получить количество активных устройств
    const activeDevicesRes = await postgresClient.query(`SELECT COUNT(*) FROM device_max_value WHERE valve_state IN ('Open valve', 'Close valve')`);
    const activeDevices = Number(activeDevicesRes.rows[0].count);

    return NextResponse.json({ devices: result.rows, totalDevices, activeDevices });
  } catch (error) {
    console.error('Error fetching all devices:', error);
    return NextResponse.json({ error: 'Failed to fetch devices' }, { status: 500 });
  }
} 