import type { Metadata } from 'next';
import { GeistSans } from 'geist/font/sans';
import { GeistMono } from 'geist/font/mono';
import './globals.css';
import { AuthProvider } from '../context/auth-context';
import { Toaster } from "../components/ui/toaster";
import { SiteHeader } from '../components/site-header';
import { ConditionalHeader } from '../user-panel/conditional-header';
import { DirectionController } from '../ui/shared/components/DirectionController';
import { I18nProvider } from '../components/I18nProvider';

export const metadata: Metadata = {
  title: 'MS4SC v1.0 App',
  description: 'Secure Authentication with Firebase',
};

export default function RootLayout({
  children,
}: Readonly<{
  children: React.ReactNode;
}>) {
  return (
    <html lang="he" className={`${GeistSans.variable} ${GeistMono.variable}`} suppressHydrationWarning>
      <body className="antialiased">
        <AuthProvider>
          <I18nProvider>
            <DirectionController />
            <div className="relative flex min-h-screen flex-col">
              <ConditionalHeader />
              <main className="flex-1 pb-16 md:pb-0">{children}</main>
            </div>
            <Toaster />
          </I18nProvider>
        </AuthProvider>
      </body>
    </html>
  );
}
