import React from 'react';
import { useTranslation } from 'react-i18next';
import { BarChart3, CreditCard, Bell, ShoppingCart, Settings } from 'lucide-react';
//import { adminTabs } from '../config/admin-tabs';
//import { useAuth } from '../hooks/use-auth';

interface AdminNavigationProps {
  activeTab: string;
  setActiveTab: (tabId: string) => void;
  tabs: Array<{ id: string; label: string }>;
  menu: Array<{ id: string; label: string; tabId: string }>;
}

const tabIcons: Record<string, any> = {
  dashboard: BarChart3,
  'payment-history': CreditCard,
  'system-notifications': Bell,
  'pending-orders': ShoppingCart,
  order: ShoppingCart,
  'user-settings': Settings,
};

export function AdminNavigation({ activeTab, setActiveTab, tabs, menu }: AdminNavigationProps) {
  const { t } = useTranslation();
  const navTabs = tabs.map(tab => ({
    ...tab,
    icon: tabIcons[tab.id] || BarChart3,
  }));

  return (
    <div className="flex flex-col lg:flex-row w-full">
      {/* Desktop Navigation */}
      <div className="hidden lg:flex lg:flex-col lg:w-64 lg:bg-gray-800 lg:text-white">
        <div className="p-4">
          <h1 className="text-xl font-bold">MS4SC Admin</h1>
        </div>
        <nav className="flex-1">
          {navTabs.map((tab) => {
            const IconComponent = tab.icon;
            return (
              <button
                key={tab.id}
                onClick={() => setActiveTab(tab.id)}
                className={`w-full px-4 py-3 text-left flex items-center space-x-3 transition-colors ${
                  activeTab === tab.id
                    ? 'bg-gray-700 text-white'
                    : 'text-gray-300 hover:bg-gray-700 hover:text-white'
                }`}
              >
                <IconComponent className="h-5 w-5" />
                <span>{t(tab.label)}</span>
              </button>
            );
          })}
        </nav>
      </div>

      {/* Mobile Navigation */}
      <div className="lg:hidden fixed bottom-0 left-0 right-0 z-50 bg-background border-t">
        <div className="flex justify-around items-center h-14 sm:h-16 px-2">
          {navTabs.map((tab) => {
            const IconComponent = tab.icon;
            return (
              <button
                key={tab.id}
                onClick={() => setActiveTab(tab.id)}
                className={`flex flex-col items-center justify-center flex-1 h-full transition-colors px-1 ${
                  activeTab === tab.id
                    ? 'text-white bg-[#1B526A]'
                    : 'text-muted-foreground hover:text-primary'
                }`}
              >
                <div className="flex items-center justify-center h-5 w-5 sm:h-6 sm:w-6">
                  <IconComponent color={activeTab === tab.id ? 'white' : undefined} />
                </div>
                <span className="text-xs sm:text-sm mt-1 font-medium text-center">
                  {t(tab.label)}
                </span>
              </button>
            );
          })}
        </div>
      </div>
    </div>
  );
} 